/***********************************************************************
*
* darts uevent.c -- Version 3.0
*
* Copyright (c)
* Steven E. Glass and Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements the
* main event loop used by the program.
*
***********************************************************************/

#include <types.h>
#include <locator.h>
#include <quickdraw.h>
#include <event.h>
#include <intmath.h>
#include <menu.h>
#include <window.h>
#include "darts.h"

extern WmTaskRec		event;
extern GrafPortPtr		theWindow;
extern unsigned int 	quitFlag, gameType, weHaveAWinner, firstUpdateComplete;
extern unsigned int 	crickettTables[NumPlayers][26], score[NumPlayers];

static GrafPortPtr	lastWindow; 		/* This private global is used in checkFrontW()
										** to prevent extra work when the windows
										** have not changed.  It is initialized
										** at the beginning of mainEvent().
										*/

extern char 	test[80];



/************************************************************************************
*
* doScore
*
* This procedure does all the scoring in this program.	It is only called when
* the user presses a button that has a non-zero low word for an ID.
*
* How the scoring works depends on the game being played.  There is a section
* for scoring each of the games.
*
************************************************************************************/
void			doScore(playerNum, amount)
unsigned int	playerNum, amount;
{
	unsigned int	otherPlayer, playerHits, otherHits, i, j;

	if (!gameType) {
		score[playerNum] += amount;
		addToList(playerNum, amount);
		invalScore(playerNum);
	}
	else {
		if (playerNum == (otherPlayer = Player1)) otherPlayer = Player2;
		playerHits = crickettTables[playerNum][amount];
		otherHits  = crickettTables[otherPlayer][amount];


		if ((playerHits < 3) || (otherHits < 3)) {		/* At least one player is open. */
			crickettTables[playerNum][amount] = ++playerHits;
			fixButtonTitle(playerNum, amount);
			if ((playerHits > 3) && (otherHits < 3)) {
				score[playerNum] += amount;
				invalScore(playerNum);
			}
			addToList(playerNum, amount);
		}

		if (!weHaveAWinner) {
			for (i = 0; i < 7; i++) {
				j = i + 15;
				if (i == 6) j = 25;
				if (crickettTables[playerNum][j] < 3) break;
			}
			if (
				(i == 7) && 		/* i is 7 when all are closed for this player. */
				(score[playerNum] >= score[otherPlayer])
			) {
				weHaveAWinner++;
				BeginUpdate(theWindow);
				drawThisWindow();
				EndUpdate(theWindow);
				AlertWindow(refIsResource * 2, NULL, 0x0003L);
			}
		}
	}
}



/************************************************************************************
*
* doControls
*
* This procedure is called by mainEvent whenever taskmaster returns inControl.
*
***********************************************************************************/
void	doControls()
{
	unsigned int	whichButton, buttonNum, lastItem, playerNum;

	if (whichButton = event.wmTaskData4) {		/* If the low word is not 0,
												** then it is a scoring control.
												*/
		playerNum = Player1;
		if (whichButton & 0x8000) playerNum = Player2;
		whichButton &= 0x7FFF;
		doScore(playerNum, whichButton);
	}
	else {
		whichButton = HiWord(event.wmTaskData4);
		switch(whichButton) {
			case 1:
				buttonNum = AlertWindow(refIsResource * 2, NULL, ConfirmTextID);
				if (buttonNum == 1) doQuitItem();
				break;
			case 2:
				doNewItem();
				break;
			case 3:
				if (event.wmClickCount > 1) {
					removeSelected(Player1);
					event.wmClickCount = 0;
				}
				break;
			case 4:
				if (event.wmClickCount > 1) {
					removeSelected(Player2);
					event.wmClickCount = 0;
				}
				break;
		}
	}
}



void	DisableItems()
{
	DisableMItem(NewItem);
	DisableMItem(QuitItem);
	DisableMItem(AboutItem);
}

void	EnableItems()
{
	EnableMItem(NewItem);
	EnableMItem(QuitItem);
	EnableMItem(AboutItem);
}



/************************************************************************************
*
* checkFrontW
*
* This routine adjusts the system menu bar depending on what window is selected.
* It activates the edit menu if a desk accessory is opened and selected.  It
* deactivates the edit menu if the game window becomes active again.
*
* We do this because it makes no sense to have progam menus active when a desk
* accessory is active and there is no sense having the edit menu active when
* this program does not use it.
*
* It is called every time through the event loop.  The global variable lastWindow
* helps us from making lots of checks if nothing has changed.
*
************************************************************************************/
void	checkFrontW()
{
	GrafPortPtr 	theWindow;

	if ((theWindow = FrontWindow()) == lastWindow) return;

	if (!theWindow) {
		SetMenuFlag(0x0080, EditMenuID);
		DrawMenuBar();
		DisableItems();
	}
	else {
		if (GetSysWFlag(theWindow)) {
			DisableItems();
			SetMenuFlag(0xFF7F, EditMenuID);
			SetMenuFlag(0x0080, GameMenuID);
			DrawMenuBar();
		}
		else {
			SetMenuFlag(0x0080, EditMenuID);
			SetMenuFlag(0xFF7F, GameMenuID);
			DrawMenuBar();
			EnableItems();
		}
	}
	lastWindow = theWindow;
}



/************************************************************************************
*
* mainEvent
*
* This is the main routine in the program.	It continuously calls taskmaster and
* handles any events that occur.  It also keeps the right menus active by
* calling checkFrontW.
*
************************************************************************************/
void	mainEvent()
{
	unsigned int	code, checkFirstUpdate;

	event.wmTaskMask = 0x001FFFFF;
	quitFlag = 0;
	checkFirstUpdate = 1;
	lastWindow = NULL;

	for (;;) {
		checkFrontW();
		code = TaskMaster(0xFFFF, &event);
		switch (code) {
			case wInSpecial:
			case wInMenuBar:
				doMenu();
				break;
			case wInControl:
				doControls();
				break;
			default:
				if (checkFirstUpdate) {
					if (firstUpdateComplete) {
						InitCursor();
						checkFirstUpdate = 0;
					}
				}
				break;
		}
		if (quitFlag) break;
	}
}
